<?php if ( ! defined( 'ABSPATH' ) ) {
	exit( 'No direct script access allowed' );
}
/**
 * Template "Plugins" for 8theme dashboard.
 *
 * @since   6.3.4
 * @version 1.0.0
 */
?>
<div class="etheme-plugins-section">
    <div class="import-demos-header etheme-plugins-header">
        <ul class="et-filters import-demos-filter">
            <li class="et-filter plugin-filter active" data-filter="all"><?php esc_html_e( 'All', 'xstore' ); ?></li>
            <li class="et-filter plugin-filter" data-filter="active"><?php esc_html_e( 'Active', 'xstore' ); ?></li>
            <li class="et-filter plugin-filter" data-filter="disabled"><?php esc_html_e( 'Inactive', 'xstore' ); ?></li>
            <li class="et-filter plugin-filter" data-filter="premium"><?php esc_html_e( 'Premium', 'xstore' ); ?></li>
            <li class="et-filter plugin-filter" data-filter="free"><?php esc_html_e( 'Free', 'xstore' ); ?></li>
        </ul>

        <div class="etheme-search">
            <input type="text" class="etheme-plugin-search form-control" placeholder="<?php esc_html_e( 'Search for plugins', 'xstore' ); ?>">
            <i class="et-admin-icon et-zoom"></i>
            <span class="spinner">
                <div class="et-loader ">
                    <svg class="loader-circular" viewBox="25 25 50 50">
                        <circle class="loader-path" cx="50" cy="50" r="12" fill="none" stroke-width="2" stroke-miterlimit="10"></circle>
                    </svg>
                </div>
            </span>
        </div>
    </div>
    <div class="manage-plugins">
		<?php
		$system = new Etheme_System_Requirements();
		$system_requirements = $system->requirements;
		$system_status = $system->get_system();
		$instance  = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
		$installed = get_plugins();
		if ( !count($instance->plugins) ) {
			echo  '<p class="et-message et-error" style="width: 100%; margin: 0 20px;">' .
                  esc_html__('Can not connect to get plugin list', 'xstore') .
              '</p>';
			echo '</div></div>';
		    return;
        }
		if ( $system_status['filesystem'] != $system_requirements['filesystem']){
		    $filesystem = false;
        } else {
			$filesystem = true;
        }
		foreach ( $instance->plugins as $slug => $plugin ) : ?>
			<?php

			$new_is_plugin_active = (
				( ! empty( $instance->plugins[ $slug ]['is_callable'] ) && is_callable( $instance->plugins[ $slug ]['is_callable'] ) )
				|| in_array( $instance->plugins[ $slug ]['file_path'], (array) get_option( 'active_plugins', array() ) ) || is_plugin_active_for_network( $instance->plugins[ $slug ]['file_path'] )
			);
			$plugin_classes       = array();
			$plugin_classes[]     = 'et_plugin';
			$plugin_classes[]     = ( $new_is_plugin_active ) ? 'et_plugin-active' : '';
			if ( isset($plugin['latest_version']) ){
				$plugin['version']  = $plugin['latest_version'];
			}

			if ( isset( $installed[ $plugin['file_path'] ] ) ){
				$plugin['version'] = $installed[ $plugin['file_path'] ]['Version'];
            }

			$filters = array();
			$filters[] = 'all';

			if ($new_is_plugin_active){
				$filters[] = 'active';
            } else {
				$filters[] = 'disabled';
            }

			if (isset( $plugin['premium'] ) && $plugin['premium']){
				$filters[] = 'premium';
			} else {
				$filters[] = 'free';
			}
			?>

            <div class="<?php echo trim( esc_attr( implode( ' ', $plugin_classes ) ) ); ?>"
                 data-slug="<?php echo esc_attr( $plugin['slug'] ); ?>"
                 data-filter="<?php echo trim( esc_attr( implode( ' ', $filters ) ) ); ?>>">
                <div class="et_plugin-content">
                    <span
                            class="plugin-action-text"
                            data-install="<?php echo esc_html__('Installing plugin', 'xstore') . ' ...'; ?>"
                            data-activate="<?php echo esc_html__('Activating plugin', 'xstore') . ' ...'; ?>"
                            data-deactivate="<?php echo esc_html__('Deactivating plugin', 'xstore') . ' ...'; ?>"
                            data-update="<?php echo esc_html__('Updating plugin', 'xstore') . ' ...'; ?>"
                    ></span>
                    <div class="et_plugin-image">
                        <div class="et_plugin-labels">
							<?php if ( $plugin['required'] ) : ?>
                                <span class="required"><?php esc_html_e( 'required', 'xstore' ); ?></span>
							<?php endif; ?>
							<?php if ( isset( $plugin['premium'] ) && $plugin['premium'] ) : ?>
                                <span class="premium"><?php esc_html_e( 'premium', 'xstore' ); ?></span>
							<?php endif; ?>
                        </div>
                        <span class="dashicons dashicons-yes et_plugin-checkbox"></span>
						<?php if ( isset( $plugin['image_url'] ) ) : ?>
                            <img src="<?php echo esc_attr( $plugin['image_url'] ); ?>"
                                 alt="<?php echo esc_attr( $plugin['slug'] ); ?>">
						<?php else: ?>
                            <span><?php esc_html_e( 'No image set', 'xstore' ); ?></span>
						<?php endif; ?>
                        <?php if ( isset($plugin['details_url']) ) : ?>
                            <a class="et_plugin-info" target="_blank" href="<?php echo esc_url($plugin['details_url'] ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="info" class="svg-inline--fa fa-info fa-w-6" role="img" viewBox="0 0 192 512" style="width: 1;width: 1em;height: 1em;">
                                    <path fill="currentColor" d="M20 424.229h20V279.771H20c-11.046 0-20-8.954-20-20V212c0-11.046 8.954-20 20-20h112c11.046 0 20 8.954 20 20v212.229h20c11.046 0 20 8.954 20 20V492c0 11.046-8.954 20-20 20H20c-11.046 0-20-8.954-20-20v-47.771c0-11.046 8.954-20 20-20zM96 0C56.235 0 24 32.235 24 72s32.235 72 72 72 72-32.235 72-72S135.764 0 96 0z"></path>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="et_plugin-info">
                    <span class="et_plugin-name">
                         <?php echo esc_html( $plugin['name'] ); ?>
                    </span>
                        <span class="et_plugin-version">
                        <?php
                        $new_is_plugin_active = (
	                        ( ! empty( $instance->plugins[ $plugin['slug'] ]['is_callable'] ) && is_callable( $instance->plugins[ $plugin['slug'] ]['is_callable'] ) )
	                        || in_array( $instance->plugins[ $plugin['slug'] ]['file_path'], (array) get_option( 'active_plugins', array() ) )
	                        || is_plugin_active_for_network( $instance->plugins[ $plugin['slug'] ]['file_path'] )
                        );
                        $is_update_available = false;
                        if (
                                $new_is_plugin_active &&
                                $instance->is_plugin_installed( $plugin['slug'] ) &&
                                (false !== $instance->does_plugin_have_update( $plugin['slug'] )
                                 || ( isset($plugin['premium']) && $plugin['premium']  && ( $plugin['latest_version'] > $plugin['version']) ) ) )
                        {
	                        $is_update_available = true;
                        }

                        $update_text = '<span class="success" style="visibility: hidden; opacity: 0;">' . esc_html__( 'Latest version', 'xstore' ) . '</span>';

                        if ($is_update_available){
	                        $update_text = '<span class="success new-version-text">' . esc_html__( 'New version available', 'xstore' ) . '</span>';
                        }

                        if ( ! $plugin['version'] ) {
	                        echo '<span class="warning">' . esc_html__( 'Can not get plugin version', 'xstore' ) . '</span>';
                        } else {
	                        printf(
		                        '<span class="current-version">v.%s</span> %s <span class="hidden new-version">%s</span>',
		                        $plugin['version'],
		                        $update_text,
		                        $instance->does_plugin_have_update( $plugin['slug'] )
	                        );
                        }
                        ?>
                    </span>
                        <div class="et_plugin-control-wrapper">

							<?php $btn_class = $install = ( ! $instance->is_plugin_installed( $plugin['slug'] ) ) ? '' : 'hidden'; ?>
                            <span
                                    class="et_plugin-control et-button et-button-green no-loader <?php echo esc_attr( $btn_class ); ?>"
                                    data-slug="<?php echo esc_attr( $plugin['slug'] ); ?>"
                                    data-action="install"><?php esc_html_e( 'install', 'xstore' ); ?></span>
	                        <?php $btn_class = $acivate = ( $instance->is_plugin_installed( $plugin['slug'] ) && ! $new_is_plugin_active ) ? '' : 'hidden'; ?>

                            <?php
                                $btn_text = __( 'activate', 'xstore' );
                                if ( $instance->does_plugin_require_update( $plugin['slug'] ) ) {
                                    $btn_text = __( 'update & activate', 'xstore' );
                                }
	                        ?>
                            <span
                                    class="et_plugin-control et-button et-button-blue no-loader <?php echo esc_attr( $btn_class ); ?>"
                                    data-slug="<?php echo esc_attr( $plugin['slug'] ); ?>"
                                    data-action="activate"><?php echo esc_html($btn_text); ?></span>

							<?php $btn_class = ( $acivate != '' && $install != '' && $is_update_available ) ? '' : 'hidden'; ?>
                            <span
                                    class="et_plugin-control et-button et-button-green no-loader <?php echo esc_attr( $btn_class ); ?>"
                                    data-slug="<?php echo esc_attr( $plugin['slug'] ); ?>"
                                    data-action="update"><?php esc_html_e( 'update', 'xstore' ); ?></span>

							<?php $btn_class = ( $acivate != '' && $install != '' ) ? '' : 'hidden'; ?>
                            <span
                                    class="et_plugin-control et-button et-button-blue no-loader <?php echo esc_attr( $btn_class ); ?>"
                                    data-slug="<?php echo esc_attr( $plugin['slug'] ); ?>"
                                    data-action="deactivate"><?php esc_html_e( 'deactivate', 'xstore' ); ?></span>

                        </div>
                    </div>
                </div>
            </div>
		<?php endforeach; ?>
        <span class="hidden et_plugin-nonce"
              data-plugin-nonce="<?php echo wp_create_nonce( 'envato_setup_nonce' ); ?>"></span>
        <span class="hidden error-text"><?php esc_html_e( 'Oops it looks something went wrong. Please check your system requirements first. In case it will happened again, please, contact us 8theme.com', 'xstore' ); ?></span>
        <span class="hidden et_filesystem" data-filesystem="<?php echo esc_js($filesystem); ?>"></span>
    </div>
</div>